package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.CaseComorbidityData;
import org.msh.tb.entities.CaseComorbidity;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;
import org.msh.utils.ObjectUtils;

import java.util.List;

/**
 * Created by rmemoria on 14/9/17.
 */
public class CaseComorbidityConsumer extends SyncDataConsumerImpl<CaseComorbidityData, Integer> {

    @Override
    public Integer consume(Tbunit unit, CaseComorbidityData data) {
        CaseComorbidity comorbidity;

        // find comorbidity by comorbidity id (field value) to guarantee that
        // it will have only 1 comorb of a type to the same case.
        List<CaseComorbidity> qryResult = getEntityManager().createQuery("from CaseComorbidity where comorbidity.id = :comorbidityId " +
                "and tbcase.id = :caseId")
                .setParameter("comorbidityId", data.getComorbidity())
                .setParameter("caseId", data.getCaseId())
                .getResultList();

        if (qryResult.size() < 1) {
            // create new instance
            comorbidity = ObjectUtils.newInstance(CaseComorbidity.class);
        } else if (data.getServerId() == null) {
            // delete all previous instance
            for (CaseComorbidity c : qryResult) {
                getEntityManager().remove(c);
            }

            // use a new instance
            comorbidity = ObjectUtils.newInstance(CaseComorbidity.class);
        } else {
            comorbidity = qryResult.get(0);
        }

        if (comorbidity.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            comorbidity.setTbcase(tbcase);
        }

        comorbidity.setComorbidity(getFieldValue(data.getComorbidity()));
        comorbidity.setDuration(data.getDuration());
        comorbidity.setComment(data.getComment());

        getEntityManager().persist(comorbidity);

        return data.getServerId() == null ? comorbidity.getId() : null;
    }
}
